"use client"

import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { ReactNode } from "react"

interface Props {
    title?: string;
    description?: string;
    children: ReactNode;
}

export function ChartCard({ title, description, children }: Props) {
    return (
        <Card>
            <CardHeader>
                <CardTitle>
                    {title}
                </CardTitle>
                {description && <CardDescription>{description}</CardDescription>}
            </CardHeader>
            <CardContent className="flex">
                <div className="flex-grow min-h-[200px]">
                    {children}
                </div>
            </CardContent>
        </Card>
    )
}
